set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9705629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '332',
      NULL,
      NULL,
      36,
      '0020400',
      36.939529,
      NULL,
      3,
      NULL,
      '030004',
      0.235209,
      ' 1- 6-2000',
      75,
      12,
      NULL,
      NULL,
      2,
      NULL,
      2.028086,
      NULL,
      0.926041,
      0,
      0.976591,
      0.125899,
      1.230500,
      0,
      1.145461,
      0.567976,
      1,
      1.017791,
      1.381623,
      1.830247,
      NULL,
      0.252932,
      1.088110,
      0.103454,
      1,
      1,
      NULL,
      1,
      NULL,
      0.176068,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921194,
      0.120707,
      0.961876,
      0.102435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.726692,
      0,
      1,
      NULL,
      1,
      NULL,
      0.828186,
      0.664939,
      NULL,
      1,
      NULL,
      1.603292,
      0.034549,
      1,
      0.894612,
      0.522294,
      0.147144,
      1.929507,
      NULL,
      1.428685,
      0.137374,
      1,
      1.513514,
      1.575726,
      0,
      NULL,
      1.443372,
      5.929149,
      NULL,
      NULL,
      0.210392,
      1.607536,
      NULL,
      NULL,
      1.231148,
      2.770360,
      0.822337,
      3,
      0,
      NULL,
      7.770559,
      1,
      1,
      3,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      2.421551,
      0.691897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196402,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0.732191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687677,
      0,
      0.025265,
      1.253354,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794760,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164432,
      NULL,
      1.999738,
      0,
      NULL,
      1.969487,
      1.267866,
      0.837898,
      1,
      1,
      0,
      0.023452,
      1,
      NULL,
      NULL,
      1.121957,
      1.525703,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.621670,
      '44310',
      NULL,
      NULL,
      0.725725,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3.546434,
      2,
      1.067366,
      0.464638,
      1,
      3.421326,
      1.077380,
      3.356464,
      1);
commit;
end;
/


