set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9705629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '32332422',
      57,
      NULL,
      '3113311',
      18,
      5,
      NULL,
      2,
      NULL,
      NULL,
      ' 0- 7-2001',
      162.934207,
      12.248922,
      1.845095,
      NULL,
      3.554314,
      1.880705,
      1,
      1,
      1,
      3.156156,
      1.613107,
      1,
      1.026943,
      NULL,
      0,
      1.884685,
      1.609010,
      1.066180,
      0,
      1.129530,
      4.823716,
      1.682705,
      NULL,
      1.531361,
      1,
      1.760531,
      0,
      0,
      3.724648,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597192,
      0.277656,
      1.066971,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870184,
      1,
      0.967366,
      0.881253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.178786,
      NULL,
      0,
      1,
      3,
      0.337391,
      NULL,
      NULL,
      1,
      1.905871,
      1.397066,
      0,
      1,
      1,
      1,
      0,
      1.991497,
      1,
      NULL,
      1,
      0.059707,
      1,
      1.622440,
      1.173856,
      0.663183,
      0.720189,
      NULL,
      NULL,
      0.050458,
      0,
      0.992479,
      0,
      0,
      0,
      1.371084,
      4.637048,
      5.108358,
      NULL,
      0,
      NULL,
      0.642219,
      0,
      NULL,
      1,
      1,
      NULL,
      0.752690,
      1.822317,
      NULL,
      NULL,
      8.843600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174885,
      1.971664,
      0,
      1,
      0,
      1,
      1,
      1.645110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356283,
      0,
      NULL,
      1.973662,
      1.950132,
      1,
      0.427012,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.782461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905243,
      0.850636,
      1,
      0.708689,
      1.982411,
      NULL,
      0,
      0,
      NULL,
      0.894217,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1.579174,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '41321',
      NULL,
      '',
      0.245165,
      '',
      '',
      NULL,
      1.630610,
      NULL,
      '',
      NULL,
      5.681796,
      2.653039,
      1.771398,
      2.344591,
      3.134945,
      NULL,
      2,
      2.391278,
      2.279481);
commit;
end;
/


