set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027300';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11',
      0.491698,
      40.872236,
      '3223023',
      24,
      6,
      3.494667,
      1,
      '230420',
      2,
      ' 2- 1-1997',
      36.986177,
      41,
      0.010630,
      NULL,
      0,
      1.876506,
      0,
      0,
      0,
      0,
      1.296008,
      1.089001,
      1.500892,
      0.198787,
      0,
      1.717539,
      0,
      1,
      1,
      1.249147,
      0.675023,
      NULL,
      0,
      1,
      1,
      0,
      2.278561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.923125,
      0.346124,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.943487,
      0,
      1.150540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.192245,
      1.269965,
      1,
      5,
      NULL,
      0.294360,
      1,
      1,
      5,
      NULL,
      NULL,
      0,
      2.046443,
      1,
      1.809116,
      1,
      1,
      0,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      3,
      0.727777,
      3.275894,
      NULL,
      1.538866,
      1,
      1,
      1.857879,
      0.926216,
      0.061823,
      7,
      6,
      NULL,
      5,
      3.669839,
      2.268020,
      2.605920,
      5.556189,
      3,
      1.211080,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.696354,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.700751,
      2.374633,
      5.778779,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.055869,
      NULL,
      3.270328,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.036497,
      0,
      NULL,
      NULL,
      NULL,
      1.914568,
      1.801610,
      2,
      5.632900,
      0.318245,
      0,
      0.027259,
      NULL,
      NULL,
      NULL,
      0,
      1.195255,
      0.871238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358002,
      0.507226,
      1,
      0,
      0.416582,
      NULL,
      1,
      0,
      1,
      2.022059,
      3,
      0,
      0.205584,
      1.012488,
      1,
      1.339214,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.681782,
      '22043',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      3.970310,
      '0404',
      NULL,
      '',
      NULL,
      0,
      4,
      2.219380,
      2.914738,
      1.617449,
      NULL,
      0.648307,
      NULL);
commit;
end;
/


