set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027300';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41400110',
      NULL,
      20.762996,
      '3002101',
      65,
      4,
      3,
      1,
      '300222',
      0,
      ' 1-25-1996',
      216,
      148.587220,
      1.458668,
      NULL,
      1.288022,
      0,
      NULL,
      0,
      1,
      0.806898,
      NULL,
      2,
      1.488285,
      1,
      0,
      1.874626,
      NULL,
      1.791223,
      1.169289,
      0,
      NULL,
      1.587240,
      0,
      0,
      0.919390,
      1,
      0.741870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.876015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.168261,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.566181,
      0.810047,
      0,
      0.910366,
      NULL,
      NULL,
      0.511626,
      0,
      0.308121,
      0,
      0,
      1.602941,
      0.904080,
      1.063955,
      0,
      0,
      1.812702,
      1,
      NULL,
      0,
      0.560616,
      1,
      NULL,
      1.691115,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.862225,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.364808,
      1.645975,
      0,
      1.471787,
      1.610656,
      0.581820,
      NULL,
      0.898426,
      NULL,
      NULL,
      NULL,
      0.832691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396538,
      0.524291,
      1,
      0,
      0,
      0.261676,
      0.478354,
      0.193404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.668176,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966416,
      NULL,
      1.854846,
      0.157453,
      1.619755,
      1,
      1.905929,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964760,
      1.372118,
      1.661542,
      1,
      0,
      1,
      0.141676,
      0.744326,
      1,
      0.534913,
      0,
      1.370414,
      0.406707,
      0,
      1.910480,
      1,
      0.840095,
      NULL,
      1.251918,
      1.711177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.627717,
      '11020',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      2.933197,
      0.913936,
      0,
      3.309033,
      1.972590,
      0.771936,
      2);
commit;
end;
/


