set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027300';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2044',
      '23423020',
      66.938310,
      28.706365,
      NULL,
      10.415781,
      NULL,
      0,
      1,
      NULL,
      4.750422,
      NULL,
      NULL,
      132.246160,
      1,
      NULL,
      1.492010,
      NULL,
      3,
      1.710826,
      0.154556,
      1,
      1,
      0.996706,
      NULL,
      NULL,
      0.741207,
      0,
      1,
      1,
      1.357595,
      1,
      1.951879,
      NULL,
      0,
      1.854415,
      NULL,
      1.793378,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.024331,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046285,
      NULL,
      1,
      0.995616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240957,
      1,
      1,
      1.255840,
      1,
      0,
      0.908800,
      1,
      1.908148,
      1,
      0,
      0.598588,
      1,
      NULL,
      0,
      1,
      NULL,
      0.746913,
      1.759405,
      1,
      1,
      0.731621,
      NULL,
      0.072806,
      3.334391,
      NULL,
      NULL,
      NULL,
      NULL,
      1.120454,
      1.954611,
      1,
      0,
      1.290956,
      NULL,
      3.123440,
      4.453235,
      0.577093,
      4,
      1.119948,
      2.666464,
      3.590806,
      0.405459,
      1.754880,
      0,
      1.848139,
      NULL,
      NULL,
      6.930504,
      0.943221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.784997,
      0,
      0,
      NULL,
      0,
      0.839102,
      0.829719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543900,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033521,
      NULL,
      0.399736,
      NULL,
      1,
      0,
      0.975138,
      NULL,
      NULL,
      NULL,
      1.538740,
      0.680671,
      1.696811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870647,
      NULL,
      1.287408,
      NULL,
      0,
      0.408743,
      NULL,
      1.677462,
      1.447520,
      1.366241,
      1.332078,
      1.152868,
      0,
      NULL,
      NULL,
      NULL,
      0.521423,
      0,
      NULL,
      0.999950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.217565,
      '',
      '',
      '',
      1,
      2,
      NULL,
      2.056236,
      0.477869,
      1.481203,
      NULL,
      3.593863,
      NULL);
commit;
end;
/


