set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '02',
      33,
      NULL,
      '1303342',
      NULL,
      1,
      1.225418,
      0,
      '220443',
      4.362078,
      NULL,
      45,
      16,
      1,
      NULL,
      3.108454,
      0.321374,
      1.247765,
      0.237644,
      1.005616,
      1,
      1,
      1.656825,
      2,
      1.361044,
      3,
      1,
      1,
      1.013460,
      2.420236,
      0,
      3.877479,
      0.793309,
      2,
      1,
      1.885870,
      1,
      1,
      0,
      5.087933,
      1,
      1,
      0.456764,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.363214,
      0.496850,
      0.304028,
      3.192317,
      NULL,
      1.662009,
      1,
      1.487640,
      1,
      1,
      0.607604,
      0.361807,
      NULL,
      0,
      0.663996,
      2,
      0,
      NULL,
      0,
      1,
      0.534073,
      0.960287,
      3,
      0,
      0,
      0.669294,
      0.301567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.983678,
      0.984393,
      1.650976,
      1,
      3,
      9,
      1,
      NULL,
      1.582654,
      NULL,
      3,
      0.377540,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.170705,
      NULL,
      1,
      1,
      2,
      4.935452,
      1,
      1,
      0,
      NULL,
      0.544018,
      1,
      1.062194,
      2,
      1.965426,
      0.644953,
      0,
      1.812346,
      0,
      1,
      2.157610,
      0,
      3,
      0.301595,
      4.781528,
      7.038137,
      2.638798,
      NULL,
      1.259339,
      0.722706,
      NULL,
      0,
      0.046976,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220811,
      1,
      1,
      0,
      1.753807,
      3.643223,
      0,
      0.989560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212133,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.075333,
      2,
      0.426538,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.539059,
      2,
      0.222412,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.693168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795631,
      1.036396,
      0,
      1.021894,
      1,
      NULL,
      1.672872,
      2.261597,
      0,
      1,
      0.356400,
      NULL,
      0,
      0.423993,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.080940,
      '14113',
      NULL,
      '',
      1.918635,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


