set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      '10223004',
      1,
      NULL,
      '3134401',
      NULL,
      0,
      1.845968,
      1,
      '102102',
      2.985704,
      ' 2-29-1992',
      37.333756,
      16,
      1.318229,
      NULL,
      0.518203,
      3,
      NULL,
      0,
      0.494420,
      1.989064,
      1.081780,
      1,
      NULL,
      1,
      1,
      1,
      0.014023,
      0.684068,
      1,
      1,
      1,
      1,
      1.598538,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.779840,
      1.160639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402268,
      NULL,
      1,
      0.943094,
      1.730077,
      1,
      NULL,
      1.856408,
      0,
      1,
      1.373901,
      0,
      1,
      1.847150,
      1,
      0,
      NULL,
      0.231953,
      0.932743,
      NULL,
      1.593898,
      NULL,
      1,
      1,
      0,
      NULL,
      4.177814,
      1,
      NULL,
      3.964309,
      1.254804,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0.933018,
      NULL,
      NULL,
      NULL,
      0,
      4,
      4.986677,
      NULL,
      0,
      0,
      NULL,
      0.746892,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.645759,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.318984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.978098,
      NULL,
      6,
      NULL,
      1,
      0.942291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.891005,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.347460,
      NULL,
      7,
      1,
      1,
      1,
      5.729076,
      1,
      NULL,
      NULL,
      0.367457,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.206472,
      0.156567,
      1,
      1.005608,
      3,
      0,
      1,
      0.141885,
      1,
      0.314052,
      0.283077,
      NULL,
      1.195694,
      1.273487,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '01104',
      NULL,
      '',
      0.091297,
      '22212',
      '',
      '',
      1.619599,
      '',
      '',
      '',
      4.004094,
      NULL,
      0,
      0.546767,
      3,
      3,
      2.233034,
      1.278387,
      NULL);
commit;
end;
/


