set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      NULL,
      40.881765,
      65,
      '4441021',
      97,
      0,
      1.012042,
      NULL,
      '130304',
      NULL,
      NULL,
      12,
      54,
      0.344170,
      NULL,
      1,
      0,
      0.510109,
      1.185392,
      1,
      NULL,
      NULL,
      NULL,
      0.482571,
      0,
      1,
      1.350291,
      1.306824,
      NULL,
      1,
      NULL,
      1,
      0.181400,
      1.067598,
      0,
      1,
      1,
      1.151369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.055770,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.283970,
      0.847874,
      1.081800,
      NULL,
      0.357809,
      1.986299,
      0.028716,
      0.625736,
      NULL,
      1,
      0.959150,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      3,
      0.692510,
      NULL,
      1,
      1.724262,
      3.810383,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.522242,
      0,
      3.782349,
      1.401058,
      1,
      0,
      2.524399,
      NULL,
      3.403118,
      1,
      3.691598,
      6,
      2,
      0,
      3,
      1.791452,
      NULL,
      NULL,
      NULL,
      6.677699,
      1.677031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.570180,
      0,
      0,
      1.205512,
      1.763463,
      NULL,
      1.075662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124093,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.260067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.417395,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.779276,
      1.677223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844225,
      1.219844,
      0,
      0.077935,
      NULL,
      1,
      1,
      3.188591,
      1.569725,
      0.807273,
      0,
      1,
      1,
      0,
      1.143700,
      0.330999,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.418784,
      '44444',
      '',
      '',
      2.876249,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      1.021359,
      0,
      0.103560,
      0.566108,
      0,
      NULL,
      0,
      NULL);
commit;
end;
/


