set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      '24002411',
      NULL,
      5,
      NULL,
      157.848162,
      2,
      2,
      3,
      '030212',
      NULL,
      ' 2-15-1978',
      3,
      48.444238,
      1.982962,
      NULL,
      1.144562,
      2.903795,
      0.054156,
      NULL,
      0,
      1,
      1.707791,
      1,
      3,
      0.223273,
      3,
      0,
      NULL,
      0,
      0.187617,
      NULL,
      6,
      0,
      NULL,
      0.737400,
      0.296746,
      0,
      1.841585,
      0,
      3.404017,
      0.145166,
      2,
      1.456889,
      NULL,
      NULL,
      0.379226,
      NULL,
      NULL,
      1,
      1.652076,
      1.113430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323046,
      1,
      0.141067,
      0.256496,
      NULL,
      0,
      0,
      1,
      NULL,
      1.437567,
      1,
      NULL,
      0,
      0,
      1.390972,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0.534998,
      6,
      1.542077,
      4,
      1,
      NULL,
      NULL,
      0.596709,
      0.958311,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.826526,
      NULL,
      1,
      NULL,
      1,
      6.626727,
      5,
      4,
      1.548048,
      1,
      NULL,
      3.657074,
      4,
      0,
      NULL,
      NULL,
      7.813739,
      1.218281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378254,
      1.478233,
      1,
      1,
      1.386837,
      0.120473,
      1.657973,
      1.747345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      1,
      0.514043,
      0.582772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.876594,
      0.443887,
      NULL,
      NULL,
      NULL,
      2,
      1.296852,
      NULL,
      NULL,
      NULL,
      1.569700,
      7.765787,
      1.431981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.835801,
      0.481143,
      0.830163,
      NULL,
      3,
      0,
      0,
      0.850997,
      0.511158,
      NULL,
      NULL,
      0.139633,
      0,
      1.603518,
      1,
      NULL,
      0.596221,
      0.286457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '12120',
      '',
      '',
      3,
      '23400',
      NULL,
      '',
      1.989313,
      '',
      '',
      '',
      2,
      NULL,
      0,
      2.016559,
      1.145581,
      3,
      1,
      1,
      2);
commit;
end;
/


