set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01043212',
      19.122064,
      28.500767,
      NULL,
      152.336686,
      2,
      3.654684,
      2,
      '234341',
      NULL,
      ' 6-24-1979',
      NULL,
      39,
      0.522095,
      NULL,
      NULL,
      0.070455,
      0.606351,
      0,
      NULL,
      NULL,
      1,
      1.494099,
      2,
      0.492238,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.260070,
      5,
      1,
      0.297395,
      0,
      0,
      0,
      NULL,
      1,
      4.889886,
      1.844796,
      3,
      1.479440,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.224598,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.683348,
      NULL,
      0.742464,
      0,
      1.660103,
      1.332488,
      0,
      0.618327,
      NULL,
      NULL,
      1,
      1.882798,
      0,
      0.273240,
      0,
      1,
      NULL,
      NULL,
      2.014852,
      NULL,
      NULL,
      3.796654,
      0,
      5.110560,
      0,
      1,
      1,
      1,
      5,
      NULL,
      0.333165,
      2.482961,
      1.170084,
      0,
      0,
      5,
      NULL,
      6,
      4,
      5,
      3,
      7,
      3,
      7,
      1.678939,
      NULL,
      NULL,
      NULL,
      6.735374,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.016642,
      3.005350,
      0,
      1,
      0.775274,
      1.325606,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7.829134,
      1,
      1.465649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376309,
      3.396629,
      1.505048,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      3,
      4.698336,
      NULL,
      4,
      1,
      NULL,
      NULL,
      1.879220,
      7,
      0.735702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634199,
      1,
      0,
      0.127045,
      3,
      1.149789,
      1,
      1,
      0.000993,
      0,
      NULL,
      1.836223,
      0.554338,
      1,
      0,
      0.392315,
      1.004276,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '24304',
      '12410',
      '',
      0.771050,
      NULL,
      '',
      NULL,
      1.965837,
      '',
      '',
      '',
      3.897466,
      NULL,
      2,
      5.596856,
      2,
      3,
      0,
      2.989144,
      2.565029);
commit;
end;
/


