set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '011',
      '14444332',
      76,
      21,
      '1400411',
      27.431045,
      5,
      1.617258,
      1,
      NULL,
      3,
      NULL,
      14,
      26.231947,
      NULL,
      NULL,
      1.357299,
      0,
      1,
      NULL,
      1.012455,
      0.358315,
      0.660319,
      0,
      2.642026,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150694,
      1,
      2.776359,
      1,
      0,
      1.519753,
      0.545592,
      1,
      2.419858,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.775643,
      0.493406,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.601328,
      5.519435,
      1.065170,
      1.654851,
      1,
      NULL,
      1,
      1.273887,
      1,
      1,
      0.587987,
      0,
      1,
      0.342501,
      1,
      1,
      0,
      0.902807,
      NULL,
      0,
      0.887518,
      NULL,
      1,
      1,
      NULL,
      4,
      1,
      2,
      2,
      3.933099,
      1.279449,
      NULL,
      0.456391,
      3,
      NULL,
      0,
      0,
      2,
      4,
      1.499354,
      6.578239,
      3,
      0.537203,
      7,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      3.321345,
      1.507437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      0.704194,
      1,
      0.350933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228396,
      NULL,
      5.024379,
      0.413590,
      0.583916,
      1.644837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.357940,
      0,
      1.420280,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.157504,
      5.402696,
      0.335440,
      0,
      1.172533,
      NULL,
      NULL,
      NULL,
      0,
      3.796654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422115,
      NULL,
      NULL,
      0,
      1.661516,
      NULL,
      NULL,
      3.185444,
      1,
      0.031206,
      1.340554,
      NULL,
      0,
      0.421569,
      1.687197,
      0.799841,
      1.763547,
      0,
      1,
      0.390877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '01023',
      NULL,
      '',
      1,
      '42324',
      '',
      '',
      1.000659,
      NULL,
      '',
      '',
      3.903459,
      0.592529,
      2.683905,
      2,
      2,
      NULL,
      0.565121,
      NULL,
      2.185249);
commit;
end;
/


