set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0110',
      NULL,
      58.540284,
      25,
      NULL,
      NULL,
      6,
      3.683074,
      NULL,
      '314421',
      0,
      ' 4- 3-1994',
      8,
      NULL,
      1,
      NULL,
      1.447895,
      0,
      0.084083,
      1,
      1,
      1.467001,
      1.063599,
      NULL,
      2.093731,
      NULL,
      NULL,
      1,
      1.411968,
      NULL,
      NULL,
      1.075219,
      6,
      1.246245,
      NULL,
      1.157904,
      1,
      1,
      5.395886,
      0,
      2,
      NULL,
      0,
      1.853630,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.842301,
      1.057906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.736298,
      0.350871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.022439,
      NULL,
      NULL,
      1.690598,
      1,
      1.150598,
      1.656351,
      0.546324,
      1,
      1,
      0,
      NULL,
      1.167506,
      1.109310,
      0.699080,
      0,
      NULL,
      1.549957,
      3.125517,
      4,
      0.197207,
      1.298443,
      1.418932,
      5.027659,
      1.115421,
      0,
      5.111875,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      5.278859,
      4.160738,
      9.055022,
      7.726232,
      0.959277,
      NULL,
      9,
      1,
      3.221085,
      0,
      NULL,
      0.983872,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738981,
      NULL,
      0,
      0,
      1,
      0,
      2.700833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.694235,
      NULL,
      7.718907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.779393,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.401286,
      0,
      NULL,
      5,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.996331,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3.045782,
      0,
      2,
      3,
      0,
      1,
      1.357445,
      0,
      NULL,
      NULL,
      0.028162,
      1.036616,
      1.738130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '23400',
      '',
      NULL,
      '10121',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      5.807788,
      NULL,
      3.989074,
      5,
      3,
      1,
      2,
      1.155697,
      2.550348);
commit;
end;
/


