set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1304',
      '21334122',
      44.246391,
      27,
      '2034311',
      142.788127,
      1,
      3.113916,
      NULL,
      '034431',
      5,
      ' 9-21-1995',
      14,
      62.143882,
      1.746633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.975400,
      NULL,
      3,
      0.620626,
      NULL,
      0,
      0.994604,
      NULL,
      1.968230,
      1,
      1,
      1.906933,
      1.008432,
      0.306449,
      1,
      1,
      3,
      1,
      2,
      0.184476,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      3,
      0.145602,
      0,
      NULL,
      1.527708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.264568,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.068778,
      0.798726,
      4,
      1,
      1,
      1,
      0.439790,
      NULL,
      1,
      1,
      NULL,
      3.194002,
      0,
      0.333272,
      NULL,
      1,
      1.545339,
      NULL,
      NULL,
      5.050942,
      3.518328,
      2.450596,
      1.005097,
      NULL,
      4.345482,
      1,
      0,
      4.615890,
      1.261492,
      NULL,
      7,
      1,
      4.106019,
      1.471001,
      6,
      0,
      0,
      8.010834,
      2,
      3,
      5,
      1.083973,
      2,
      0,
      9.041015,
      NULL,
      2.068429,
      1.759039,
      NULL,
      0.458413,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.644496,
      2,
      2,
      1.619821,
      NULL,
      5.214188,
      0.484142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.990196,
      NULL,
      3.166064,
      2.085926,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      2.328567,
      1,
      1.445256,
      1.114997,
      0.781897,
      NULL,
      5.773813,
      0.322337,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4.413212,
      0,
      1.810602,
      5,
      1.573173,
      NULL,
      0,
      0,
      NULL,
      1.234709,
      NULL,
      0,
      1.802262,
      0.070197,
      0,
      1.118586,
      0,
      1,
      1.317925,
      1,
      1.252854,
      1.152197,
      1,
      0.442475,
      1.281118,
      0,
      0.450794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '33030',
      '11321',
      '',
      2.024998,
      '20204',
      '',
      '',
      5.721938,
      '33401',
      '2114',
      '',
      NULL,
      5,
      0,
      4.217109,
      0,
      NULL,
      0,
      0.455823,
      2.433128);
commit;
end;
/


