set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0024',
      '40423130',
      11,
      39,
      NULL,
      75,
      1,
      1,
      NULL,
      NULL,
      NULL,
      ' 3-10-1990',
      NULL,
      22,
      1,
      NULL,
      1.269964,
      2.767384,
      0,
      0,
      0,
      2,
      1.081584,
      0,
      0,
      1,
      1.953245,
      NULL,
      NULL,
      NULL,
      1,
      1,
      9,
      0,
      1,
      1,
      NULL,
      NULL,
      5.408052,
      0,
      0,
      0.481351,
      3,
      0.723964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782580,
      0.967946,
      0.532603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.046166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.964184,
      3.982486,
      3,
      1,
      NULL,
      3.184602,
      4.396422,
      0.322530,
      0,
      1.649042,
      0,
      NULL,
      0,
      0.758575,
      1.335247,
      1,
      1.107696,
      0.238558,
      NULL,
      NULL,
      0,
      3.754535,
      1.756480,
      5,
      0.797698,
      0.050881,
      NULL,
      1.542192,
      1,
      NULL,
      3,
      4,
      4,
      1.782388,
      4,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      9.416793,
      2.725571,
      0.881739,
      7,
      2,
      NULL,
      1,
      4.046206,
      0.930430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.824185,
      0,
      3.191539,
      1.957080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2.750576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.969594,
      0.784768,
      0.662746,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      5.613414,
      1.226970,
      2,
      0.481303,
      NULL,
      NULL,
      NULL,
      0,
      6.305964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      3.245915,
      2,
      3.686454,
      NULL,
      0,
      1.347110,
      0,
      1,
      1.458827,
      1.188953,
      1.396248,
      NULL,
      0,
      1,
      0,
      0.305094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '43234',
      '44412',
      '',
      1,
      '33421',
      '',
      NULL,
      3,
      '00203',
      '13100',
      NULL,
      4,
      0,
      NULL,
      0.129783,
      0,
      1.671014,
      NULL,
      3.367359,
      3.374471);
commit;
end;
/


