set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '3114423',
      NULL,
      6,
      0,
      2,
      '033320',
      NULL,
      NULL,
      24.073324,
      NULL,
      1.674025,
      NULL,
      1,
      0.970059,
      1.177307,
      0.713508,
      NULL,
      1.341278,
      1.832584,
      0,
      1.214858,
      1.349990,
      NULL,
      1.487889,
      1,
      NULL,
      2,
      0.782584,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      4,
      1,
      0.507346,
      2,
      0,
      1.750196,
      NULL,
      NULL,
      0.388657,
      NULL,
      NULL,
      1.756699,
      1,
      NULL,
      1.022097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.923839,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.900557,
      4,
      0.280212,
      1.747389,
      NULL,
      4.161397,
      NULL,
      2,
      5.154710,
      4.391382,
      0.643567,
      0.382001,
      7.160101,
      NULL,
      1.343609,
      1.333920,
      1,
      0.473191,
      NULL,
      1.990978,
      1.567197,
      2,
      1.462277,
      NULL,
      1,
      1.752021,
      NULL,
      NULL,
      0.119500,
      2.062876,
      0.890297,
      NULL,
      NULL,
      2.700097,
      2.157778,
      0,
      NULL,
      NULL,
      7,
      7.519409,
      4,
      1,
      3,
      NULL,
      4,
      3.851375,
      4,
      1,
      NULL,
      1.674935,
      9,
      1.292997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539056,
      5.942444,
      1,
      0,
      NULL,
      1,
      0.181236,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.700440,
      0,
      NULL,
      NULL,
      NULL,
      0.968434,
      NULL,
      5,
      4.909857,
      4.307291,
      NULL,
      1.980583,
      NULL,
      NULL,
      NULL,
      0,
      0.297178,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.872916,
      3.423340,
      NULL,
      NULL,
      0,
      1.766176,
      1.310043,
      0.037648,
      1,
      NULL,
      NULL,
      1,
      1.874396,
      0,
      1.139391,
      1.424525,
      0.127913,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.393581,
      '10342',
      '',
      '',
      1.984752,
      '',
      '',
      '',
      3.826513,
      '44340',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


