set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '3332332',
      33.416180,
      3,
      2.634961,
      3,
      '124200',
      0,
      NULL,
      12,
      NULL,
      1,
      NULL,
      5,
      1.285854,
      1.877952,
      0.685080,
      1,
      1.362762,
      1,
      0.747850,
      NULL,
      1.649166,
      2.402257,
      1.512666,
      1.850901,
      1.758646,
      1.814270,
      NULL,
      0.453985,
      NULL,
      0,
      1,
      0.317893,
      0.642487,
      1,
      1,
      NULL,
      NULL,
      1.907467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.051683,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049655,
      NULL,
      1,
      0.977099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3.704047,
      NULL,
      5.230577,
      NULL,
      5.481860,
      0.297674,
      NULL,
      5,
      0,
      2.688323,
      1,
      NULL,
      1.123682,
      0.138108,
      0,
      0.740968,
      1,
      NULL,
      1,
      NULL,
      2,
      0,
      1.673599,
      0,
      NULL,
      1,
      NULL,
      0.938957,
      NULL,
      4,
      1,
      1.013782,
      3,
      1.228347,
      1.216250,
      5,
      1.661950,
      5,
      4,
      NULL,
      3.518945,
      2,
      2.188235,
      2.575057,
      NULL,
      NULL,
      3.916538,
      1.964815,
      1,
      6,
      0.118290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      0,
      1,
      1,
      1.791202,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.070051,
      1,
      0,
      4.421287,
      3.664918,
      1.347209,
      NULL,
      0.808572,
      2,
      3.195909,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.769276,
      1.617294,
      1,
      NULL,
      NULL,
      NULL,
      1.270433,
      NULL,
      NULL,
      NULL,
      0.135837,
      0.541893,
      0.023811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.630141,
      0.743955,
      3,
      1.384930,
      1,
      1.015834,
      3,
      3.176862,
      1.041743,
      0.570184,
      0.713650,
      1.178240,
      1.566836,
      0,
      0.665425,
      0.778424,
      0.031268,
      0,
      1.575055,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '32200',
      '',
      '',
      0.530607,
      '',
      '',
      '',
      1.364323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


