set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '2433203',
      91.427779,
      4,
      0.481735,
      0,
      NULL,
      0.053525,
      '10-29-1985',
      35,
      NULL,
      0,
      NULL,
      1,
      0.736995,
      1,
      NULL,
      0.074227,
      NULL,
      NULL,
      0,
      1.910209,
      NULL,
      1,
      1.316288,
      NULL,
      2,
      NULL,
      1,
      2,
      1,
      1,
      0.560581,
      2,
      2,
      5,
      1,
      3.991198,
      NULL,
      NULL,
      0.485118,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.745182,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.390601,
      0.337333,
      0.847370,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.519359,
      NULL,
      NULL,
      NULL,
      0.568446,
      4,
      1,
      0,
      NULL,
      4.555031,
      0,
      NULL,
      2.587763,
      0,
      1,
      0,
      NULL,
      1.473681,
      0,
      0.797828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941231,
      1.872606,
      NULL,
      0.053668,
      NULL,
      1,
      0.938400,
      0,
      1,
      1.397260,
      0.163313,
      1,
      0,
      1.223075,
      1,
      NULL,
      4.335806,
      NULL,
      7,
      NULL,
      NULL,
      5.349519,
      NULL,
      3,
      9,
      NULL,
      2.050515,
      1,
      1,
      2.454635,
      1.836201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.691113,
      0,
      0,
      0.470034,
      1.208682,
      0,
      1.221144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127173,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.141230,
      0,
      0.354759,
      2.184676,
      0.047800,
      2.159962,
      1.147140,
      1.004821,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.546605,
      3.096002,
      4.559999,
      NULL,
      3.762038,
      NULL,
      NULL,
      NULL,
      NULL,
      4.441042,
      1.088293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446105,
      0,
      1.272949,
      2,
      0.055468,
      3,
      0.500611,
      NULL,
      2,
      1,
      1.622601,
      0,
      1.660526,
      1.945530,
      0.592210,
      1,
      0.431528,
      0,
      1.886240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '14240',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '14103',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


