set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '4134142',
      128.453361,
      2,
      1,
      1,
      NULL,
      0.983677,
      ' 6-14-1974',
      0,
      NULL,
      0.662422,
      NULL,
      4.398933,
      0.772162,
      0.407240,
      NULL,
      0.505898,
      2.936114,
      1,
      0,
      0.434374,
      0.407060,
      3.543344,
      1,
      3.232946,
      1.365529,
      0,
      1,
      0.069551,
      0,
      0,
      1,
      3,
      NULL,
      2,
      1,
      NULL,
      0.308309,
      0,
      1.750395,
      NULL,
      NULL,
      0.719662,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066219,
      7.441557,
      1.810002,
      2.374412,
      7.576144,
      0.940923,
      3.502584,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.266207,
      1,
      NULL,
      1.121267,
      0.292454,
      0,
      NULL,
      1.574059,
      7,
      0,
      0,
      NULL,
      1.806045,
      3.119653,
      1.203194,
      5,
      1,
      3.277332,
      7.645951,
      0,
      1,
      6,
      0.432688,
      7.955775,
      7.990110,
      NULL,
      NULL,
      5.454545,
      1.100267,
      7,
      8,
      9.471539,
      5,
      5,
      1.312353,
      2,
      0.356288,
      1.717565,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1.226225,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.622817,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768529,
      NULL,
      0,
      0.624708,
      NULL,
      1.368668,
      4.561161,
      1.026304,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.211047,
      1.759156,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.076652,
      0.802602,
      0.956391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.296515,
      1.488034,
      0.661846,
      1,
      3.338035,
      NULL,
      3.839393,
      0,
      3.791170,
      2,
      0.582268,
      1.825655,
      1.731689,
      1,
      0.816624,
      1.726379,
      0,
      1,
      1.829235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.521926,
      '12331',
      '',
      '',
      0.782607,
      '',
      '',
      '',
      3.930274,
      '11040',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


