set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '1010324',
      67,
      2,
      2,
      1,
      NULL,
      1,
      ' 5- 3-1986',
      20.730403,
      NULL,
      0,
      NULL,
      NULL,
      1.658349,
      0.846920,
      NULL,
      0.463789,
      3.605406,
      1.336957,
      NULL,
      NULL,
      0.902592,
      0.396390,
      1.453176,
      0.389821,
      NULL,
      0,
      1.878101,
      10,
      0,
      NULL,
      0,
      0.423308,
      NULL,
      4,
      NULL,
      0,
      0.494759,
      0.232941,
      1.261122,
      NULL,
      NULL,
      0.787440,
      NULL,
      NULL,
      2,
      3.567372,
      5.846699,
      0,
      3.904189,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.301152,
      NULL,
      NULL,
      0,
      NULL,
      1.967509,
      0.669313,
      0.622715,
      2,
      0.080578,
      0,
      NULL,
      1,
      NULL,
      0.340349,
      0.126081,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.290307,
      0,
      3,
      0.315369,
      1,
      1,
      NULL,
      0.024644,
      0,
      0.853798,
      0.950519,
      NULL,
      1,
      1.100226,
      1.042456,
      1.980523,
      1,
      0.092022,
      0,
      NULL,
      0.239034,
      1.905051,
      0.889497,
      1,
      0.033851,
      0.713728,
      2.095878,
      NULL,
      0,
      0,
      0,
      5.176527,
      2,
      NULL,
      1.963388,
      NULL,
      1.484870,
      4.386018,
      7.081590,
      NULL,
      1.709502,
      NULL,
      NULL,
      4,
      NULL,
      4,
      4.187943,
      1,
      3.602634,
      1.794268,
      1.773836,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.878644,
      1,
      1,
      0.520404,
      1.048744,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.518931,
      1.032628,
      2,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2.211630,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.748125,
      0,
      3,
      NULL,
      3,
      2.181287,
      1,
      2,
      0,
      1,
      1.634235,
      1,
      NULL,
      0,
      0,
      1,
      1.945543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '43230',
      NULL,
      '',
      1.391943,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


