set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      '30',
      45,
      15,
      NULL,
      152,
      0,
      2.164217,
      2,
      '213144',
      3.368579,
      ' 4-15-1976',
      40,
      33.413107,
      NULL,
      NULL,
      0.358885,
      0.114082,
      NULL,
      1,
      3,
      1.632216,
      1,
      0.219021,
      0.744627,
      1.807019,
      3.156979,
      1,
      NULL,
      1,
      0.866468,
      1.577408,
      0.488699,
      1.429751,
      0,
      NULL,
      NULL,
      0,
      3.603025,
      1,
      3.688962,
      0.067818,
      3,
      NULL,
      NULL,
      NULL,
      1.235674,
      NULL,
      NULL,
      0,
      1.615568,
      3.733907,
      0.859663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.854539,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100778,
      0.797693,
      1,
      0,
      0,
      1,
      1,
      1,
      1.952134,
      NULL,
      0.768149,
      1.657031,
      1.684280,
      0.311644,
      0.263675,
      0.892816,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.681217,
      0,
      1.047282,
      1.421036,
      NULL,
      1.607873,
      NULL,
      0,
      0.188475,
      0.806930,
      4.527111,
      NULL,
      0,
      5.815739,
      2.726760,
      NULL,
      5.423216,
      7,
      2,
      2.787190,
      5,
      1.292466,
      4.885142,
      6.286038,
      2.972215,
      NULL,
      2.305450,
      2.176900,
      1,
      NULL,
      7.400104,
      0.429834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.628584,
      1,
      0,
      1,
      1,
      1,
      0.158113,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.412852,
      2,
      0.889981,
      1,
      0.732179,
      7,
      0,
      0.164693,
      NULL,
      NULL,
      NULL,
      1.353136,
      NULL,
      NULL,
      4.548804,
      3.731185,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.448329,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048203,
      0.673041,
      3,
      NULL,
      0,
      0.736306,
      1,
      0,
      0,
      1.271732,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1.540925,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.933673,
      '13223',
      '',
      NULL,
      1.935284,
      '',
      '',
      NULL,
      NULL,
      '41013',
      '',
      NULL,
      1.707599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


