set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      NULL,
      41,
      NULL,
      NULL,
      235,
      5,
      2,
      3,
      '103114',
      NULL,
      NULL,
      NULL,
      3.087437,
      0.518405,
      NULL,
      4.801713,
      NULL,
      0.365394,
      0,
      0,
      2.362472,
      NULL,
      NULL,
      1,
      1.484929,
      7.902601,
      0,
      NULL,
      3,
      2.991322,
      1,
      0.233816,
      1,
      0,
      1,
      NULL,
      1.752708,
      6.957817,
      0,
      NULL,
      0,
      0.142653,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.058896,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.041103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.651167,
      6,
      0,
      NULL,
      1.882417,
      NULL,
      1.769528,
      0,
      0.450304,
      1,
      1.660756,
      1.845460,
      0.787695,
      0.480765,
      1,
      1.001810,
      NULL,
      1,
      5.694890,
      1,
      NULL,
      1,
      NULL,
      2.783858,
      0.937885,
      3.318719,
      0.593465,
      0,
      0,
      4.199535,
      1.016036,
      4,
      0.085234,
      4,
      5,
      1,
      5,
      2,
      4.901434,
      3.727914,
      11.585846,
      4.889108,
      3.157473,
      NULL,
      1,
      2,
      1.937234,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0.860645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.230888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.200718,
      NULL,
      2.945964,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171130,
      1.856900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920615,
      NULL,
      3,
      1,
      0.934206,
      1.099141,
      0,
      NULL,
      0.591274,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1.084838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '00213',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '41240',
      '',
      '',
      1.181810,
      1,
      1.222515,
      0.480106,
      2,
      NULL,
      3.455854,
      1.884451,
      0.993294);
commit;
end;
/


