set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '0320133',
      8.380388,
      2,
      NULL,
      NULL,
      '344114',
      2.022360,
      NULL,
      56,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0.354467,
      2,
      2.710220,
      NULL,
      0,
      0.112831,
      2.089055,
      NULL,
      1.529666,
      0,
      0,
      1.211173,
      5.580802,
      1,
      0,
      0.784585,
      1,
      1.900980,
      4.973606,
      1,
      2,
      1.791153,
      1,
      1.086954,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0.349707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924376,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191634,
      1.305159,
      NULL,
      1,
      NULL,
      0.655280,
      0,
      0.094638,
      1.081243,
      0.531029,
      0.585207,
      1,
      1.148695,
      0,
      1.119270,
      1,
      0.679735,
      0,
      0.256326,
      NULL,
      1.727590,
      0,
      2.903984,
      1.527524,
      1.349327,
      0,
      1.266513,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773038,
      0.234173,
      1.215990,
      0.885761,
      1.333668,
      1,
      0.578073,
      0.426001,
      1.618123,
      3.452218,
      NULL,
      NULL,
      2,
      NULL,
      3.932237,
      0.446764,
      0,
      1.343818,
      NULL,
      NULL,
      0.529804,
      1.672054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040481,
      1.740773,
      1,
      0,
      0,
      0.480430,
      1.208973,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.703099,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.701164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675229,
      2,
      1,
      0,
      0.945370,
      0,
      0.438795,
      NULL,
      1.472599,
      NULL,
      0.737341,
      NULL,
      1.515280,
      NULL,
      1.107914,
      0,
      0,
      NULL,
      1.989412,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '20102',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.446679,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


