set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      '00',
      26,
      1.105957,
      '2203321',
      80,
      4,
      NULL,
      0,
      '244241',
      5,
      ' 1- 8-1994',
      41,
      49,
      1.265229,
      NULL,
      0.841880,
      2.003961,
      NULL,
      1,
      1.455741,
      0.849061,
      NULL,
      3.581133,
      0.914666,
      NULL,
      3,
      0.662864,
      NULL,
      0,
      1,
      1.006593,
      0.432628,
      0,
      0.271608,
      0.497913,
      NULL,
      0,
      NULL,
      0,
      0.779822,
      1,
      0,
      0.416951,
      NULL,
      NULL,
      1.389023,
      NULL,
      NULL,
      0.516717,
      1.200193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111601,
      NULL,
      0.022387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.300891,
      1,
      0.130390,
      1,
      NULL,
      1,
      1,
      0,
      0.975704,
      NULL,
      1.469155,
      0.051033,
      0.847439,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.020845,
      1,
      0.112734,
      1.142945,
      0,
      NULL,
      NULL,
      0.498236,
      1,
      1,
      0,
      1,
      1,
      1.148840,
      3,
      1.399012,
      6,
      0,
      1,
      NULL,
      2.931566,
      0.515579,
      1,
      NULL,
      0.356241,
      NULL,
      NULL,
      8.316563,
      0.401173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534551,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0.055722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.967981,
      NULL,
      4,
      NULL,
      1,
      3.080298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.140696,
      0.158740,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.056143,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.534227,
      0.153859,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.376582,
      NULL,
      1.842969,
      0.108723,
      1.449147,
      1.262871,
      0.440395,
      2,
      0.365453,
      1.743084,
      1,
      1,
      1.094522,
      NULL,
      1,
      0.286474,
      0.534842,
      1.352352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '40433',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      1.331477,
      NULL,
      '',
      '',
      0.363328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


