set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '30',
      26.297624,
      0.746887,
      '2044301',
      NULL,
      5,
      3,
      2,
      '101114',
      5,
      ' 2-21-1988',
      50,
      32.369197,
      1.677257,
      NULL,
      0.225004,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      1.084247,
      0,
      0.750031,
      3.329390,
      1,
      1.662484,
      NULL,
      0.363671,
      NULL,
      4.522516,
      0,
      NULL,
      NULL,
      1.872720,
      1,
      2.286132,
      1,
      NULL,
      1.897457,
      1,
      NULL,
      NULL,
      NULL,
      1.902803,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.724490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613999,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436352,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0.474439,
      NULL,
      0.302647,
      0.599815,
      1.414058,
      1.279299,
      1.662910,
      1,
      1.911087,
      0.115176,
      1.537265,
      NULL,
      1.127861,
      1.184012,
      0.149558,
      1,
      1,
      1.604214,
      1.549953,
      1.307019,
      NULL,
      1,
      NULL,
      0,
      0.235931,
      0.492265,
      NULL,
      1.748059,
      NULL,
      NULL,
      5.128831,
      NULL,
      NULL,
      NULL,
      3.896335,
      6,
      6.509628,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.081804,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.184862,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.166191,
      NULL,
      3.952126,
      NULL,
      1.944436,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.088993,
      1,
      1.788417,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.285685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429381,
      3,
      2.907529,
      1.720202,
      3,
      0.440340,
      NULL,
      0.436898,
      1,
      0.255549,
      NULL,
      0,
      0.581317,
      NULL,
      NULL,
      0,
      NULL,
      1.925020,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.827824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '40430',
      '',
      NULL,
      0.701154,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3.292913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


