set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      '31',
      11,
      NULL,
      NULL,
      104.172475,
      5,
      NULL,
      0,
      '042143',
      3.650305,
      ' 8-26-1995',
      8,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.070947,
      1,
      1.888101,
      0,
      NULL,
      1,
      1.189987,
      5.238255,
      0,
      2.449337,
      0.021752,
      1,
      3,
      3.295238,
      0,
      0,
      0.140830,
      1.837080,
      1.842752,
      NULL,
      1,
      0.781532,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.681971,
      NULL,
      1.423149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.774387,
      0,
      1,
      1.585725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.164147,
      1.924206,
      0.912168,
      NULL,
      0,
      0,
      0.275863,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.990033,
      1,
      1,
      1.338898,
      0,
      NULL,
      0.749237,
      0.552622,
      0,
      1,
      0.671935,
      1.421249,
      1.568584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.311045,
      NULL,
      3.665475,
      2,
      5.436662,
      3.113845,
      5,
      7,
      5.841165,
      NULL,
      NULL,
      4.434998,
      1,
      1,
      NULL,
      NULL,
      0,
      1.186570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359913,
      1.476324,
      1,
      1,
      0.136330,
      1.305222,
      1.813430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.769409,
      0.635822,
      1.354994,
      NULL,
      NULL,
      NULL,
      0.511862,
      0.132947,
      5,
      NULL,
      2.019248,
      NULL,
      1.403383,
      NULL,
      NULL,
      NULL,
      0,
      3.390384,
      1.384230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973632,
      3.085059,
      NULL,
      1.623641,
      0,
      1.147497,
      1,
      1.366435,
      0,
      0,
      1.216769,
      1,
      1,
      NULL,
      1,
      0.667797,
      0,
      0,
      0.735606,
      1.957191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.857472,
      '01140',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2.587671,
      5,
      5,
      NULL,
      1.972640,
      NULL,
      NULL,
      0.337769,
      NULL);
commit;
end;
/


