set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '234',
      NULL,
      NULL,
      55.715408,
      '1021243',
      115.200094,
      1,
      3.130918,
      3,
      '442230',
      1,
      NULL,
      37,
      49.356850,
      NULL,
      NULL,
      1.987865,
      1.449769,
      1.234254,
      0.781099,
      0,
      0,
      0.565001,
      1.858424,
      1,
      1,
      2.365931,
      1,
      0,
      1.306542,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.688446,
      0.859673,
      1.408484,
      1.164812,
      0,
      0.841284,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.485956,
      1.895464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      5,
      1,
      0,
      1.008260,
      1.011998,
      NULL,
      NULL,
      1.513897,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1.409187,
      NULL,
      1,
      NULL,
      0.888905,
      0,
      1.092658,
      NULL,
      NULL,
      NULL,
      1.451233,
      0.026841,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.243752,
      NULL,
      0.143903,
      1,
      1,
      2.394653,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418792,
      0.649107,
      5,
      1,
      0.747303,
      NULL,
      1.136491,
      1,
      3.334388,
      NULL,
      2,
      3,
      NULL,
      4.654447,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597927,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.816877,
      1.889193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.872470,
      NULL,
      8,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.131015,
      2,
      NULL,
      0.095807,
      0,
      NULL,
      0,
      1.983766,
      NULL,
      5.484584,
      NULL,
      0.934794,
      NULL,
      NULL,
      NULL,
      NULL,
      3.448352,
      1.492824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380467,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.096448,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '43342',
      NULL,
      '',
      3,
      '20343',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      4.132823,
      0,
      0,
      2,
      3.906889,
      NULL,
      1.389922,
      3);
commit;
end;
/


