set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8731046';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '2403422',
      2,
      NULL,
      1.937495,
      0,
      '133302',
      3.732053,
      ' 1- 3-1991',
      35,
      NULL,
      1.578021,
      NULL,
      3.556087,
      1.864279,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0.664094,
      NULL,
      4,
      1,
      0.467409,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.693039,
      NULL,
      0.178232,
      0.328526,
      3,
      0,
      0.026910,
      NULL,
      NULL,
      1.348676,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.363862,
      1,
      NULL,
      1.680546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.178155,
      1.677771,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      0,
      1,
      0.633989,
      2,
      NULL,
      4,
      1.932553,
      0.076370,
      NULL,
      0.147178,
      0.556678,
      1,
      1,
      0,
      NULL,
      0.386218,
      7,
      2,
      0.532922,
      0.489222,
      2.454600,
      NULL,
      1,
      5,
      6.998199,
      3,
      0,
      4,
      3,
      NULL,
      0.627507,
      7,
      11.590540,
      8.744716,
      7.411719,
      4,
      1.547080,
      9.304843,
      8.863817,
      10,
      2,
      NULL,
      4,
      0,
      NULL,
      NULL,
      5.993086,
      1.204918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153212,
      0,
      1,
      NULL,
      0,
      0.611333,
      1,
      1.373278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.895469,
      0.928190,
      1.464552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.039483,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0.347853,
      NULL,
      NULL,
      NULL,
      1.230944,
      4.106908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.259817,
      3,
      0,
      2,
      NULL,
      2.141284,
      1.138753,
      3.226712,
      1.893070,
      0.174020,
      1,
      NULL,
      0.233052,
      NULL,
      NULL,
      1.979528,
      1.298656,
      1,
      1.329482,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.830277,
      '21302',
      '',
      '',
      NULL,
      '02342',
      NULL,
      '',
      0.768261,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


