set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      '44243133',
      60,
      22.730888,
      '2304033',
      0.944450,
      1,
      NULL,
      3,
      '044431',
      NULL,
      ' 2-17-1975',
      116.425237,
      88.783681,
      0.215276,
      NULL,
      1.537454,
      0.481542,
      2.418521,
      0.802697,
      1.153118,
      1.884472,
      2.562856,
      1,
      NULL,
      0,
      1.865033,
      0,
      NULL,
      1,
      0.778184,
      1,
      6.595156,
      1,
      NULL,
      0.859350,
      1.814547,
      0,
      1.075217,
      NULL,
      3,
      2.421521,
      1.304755,
      NULL,
      NULL,
      NULL,
      1.310834,
      NULL,
      NULL,
      NULL,
      2,
      1.839172,
      NULL,
      0,
      1.041584,
      2,
      2.768061,
      1,
      2.384857,
      NULL,
      0.192202,
      0,
      NULL,
      1,
      2,
      2,
      0,
      1.366474,
      0,
      NULL,
      3.307402,
      3.462820,
      0,
      2,
      NULL,
      0.199394,
      NULL,
      NULL,
      1.209894,
      NULL,
      NULL,
      0.532680,
      NULL,
      1,
      0.738100,
      2,
      NULL,
      1.629164,
      0.923903,
      0.541936,
      4,
      0,
      NULL,
      0,
      3,
      0.532487,
      1.597987,
      0.264719,
      0.969544,
      1.487307,
      NULL,
      0.603898,
      1,
      NULL,
      1.034523,
      1,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328798,
      3.612868,
      NULL,
      3,
      0,
      9.737676,
      4.101511,
      0,
      7,
      1,
      5.178785,
      5,
      4,
      1.467530,
      NULL,
      1.456814,
      NULL,
      1.455133,
      NULL,
      0.698926,
      1.147721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639015,
      1,
      1,
      0,
      0.378365,
      0.004235,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335635,
      1.562019,
      3.044565,
      1.494142,
      2.011855,
      NULL,
      1.406397,
      3,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.686491,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376341,
      2,
      1.513549,
      NULL,
      1,
      NULL,
      0.992007,
      NULL,
      0.689540,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748862,
      0.619656,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806483,
      '13124',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      NULL,
      2.512466,
      3,
      3,
      5,
      0.398119,
      2.018090,
      1,
      3);
commit;
end;
/


