set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '21010141',
      64.058463,
      28,
      '2424114',
      6.247601,
      3,
      0.355072,
      2,
      '011234',
      3,
      ' 1- 1-1989',
      NULL,
      6,
      1.451276,
      NULL,
      1,
      1.228384,
      3.479390,
      0.664116,
      1.767729,
      NULL,
      0.360806,
      1,
      1.765494,
      NULL,
      7.405210,
      NULL,
      NULL,
      1.543981,
      3,
      0.383528,
      8,
      0.067943,
      2,
      0.866767,
      0.154768,
      0,
      NULL,
      1,
      3,
      1,
      1.609556,
      1.441396,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5.695018,
      NULL,
      0,
      0.881820,
      NULL,
      NULL,
      2,
      1.694481,
      1.337010,
      NULL,
      1,
      0,
      1,
      1.190276,
      1,
      2.659926,
      1.127664,
      1.379638,
      1,
      1,
      2,
      5,
      1,
      1,
      0.867251,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.577794,
      2,
      1,
      1.456370,
      NULL,
      4.934932,
      0,
      1.253237,
      0.972908,
      0,
      0.044297,
      0.479171,
      1,
      3,
      NULL,
      0,
      0,
      1,
      0.243620,
      NULL,
      0.158631,
      NULL,
      0.723613,
      1.975443,
      NULL,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.290592,
      1.290659,
      3,
      0.506683,
      0.705500,
      7.969443,
      4,
      0.272949,
      NULL,
      1,
      6.589126,
      0,
      2,
      1,
      1,
      NULL,
      3.468520,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.046286,
      1,
      0,
      1,
      1.963430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.329672,
      NULL,
      1,
      4,
      NULL,
      0,
      1.206404,
      1,
      0,
      0.561852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484720,
      2.606513,
      2.352721,
      1,
      4.819719,
      1,
      2.579439,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380403,
      NULL,
      0,
      2,
      1,
      0,
      3.553185,
      0.831249,
      NULL,
      0.072010,
      0,
      1,
      NULL,
      1.562460,
      0,
      1.902018,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.526255,
      '10331',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      4,
      NULL,
      NULL,
      0.567482,
      3,
      NULL,
      0.844545,
      2.591267,
      1);
commit;
end;
/


