set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01223211',
      40,
      27.430321,
      '2200302',
      8.290429,
      3,
      NULL,
      NULL,
      '124121',
      5,
      '11- 3-2002',
      161.009567,
      19.967651,
      0,
      NULL,
      NULL,
      1,
      1,
      0.750294,
      1.026926,
      0,
      0.272589,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      0.137400,
      NULL,
      1,
      7.190021,
      0.116551,
      0,
      0.836583,
      0,
      1.165843,
      3.319663,
      NULL,
      2,
      2.980607,
      1.053306,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      1,
      1,
      0.022777,
      NULL,
      NULL,
      2.891548,
      0,
      2,
      3.756866,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      3.858854,
      3.426138,
      0.506137,
      1.541335,
      0.823890,
      1.041020,
      NULL,
      1,
      3.052777,
      1.146577,
      NULL,
      NULL,
      0.025310,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.673300,
      1,
      0,
      0.302905,
      0.594166,
      1.157364,
      NULL,
      0.657165,
      NULL,
      0,
      0.047326,
      NULL,
      0.293779,
      1,
      1.025329,
      0,
      NULL,
      1.224142,
      1,
      1.806989,
      1.016836,
      0.773986,
      0.524967,
      NULL,
      2.839952,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      4.934639,
      0.058186,
      0,
      5.565012,
      5,
      NULL,
      NULL,
      2.097116,
      2,
      3.445992,
      7.867224,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      0.102765,
      1.663502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.032800,
      1.697397,
      0.234008,
      1.087119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      1,
      0,
      5.766912,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.001947,
      2,
      1,
      0.268686,
      2.444558,
      1.526870,
      1.283431,
      0,
      0.629270,
      1,
      0,
      1,
      0.819051,
      1,
      0.710758,
      1,
      0,
      0.376306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372185,
      '01322',
      '',
      '',
      0.990713,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      5.679104,
      NULL,
      2,
      1,
      NULL,
      1.259549,
      NULL,
      1.198579,
      0.643818);
commit;
end;
/


