set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3420',
      '21334410',
      22,
      14,
      '4424421',
      4,
      2,
      NULL,
      2,
      '244112',
      6,
      ' 2-14-1986',
      195,
      54,
      0.784475,
      NULL,
      0.588232,
      0.914159,
      0,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      2.992661,
      1,
      0.754081,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0.034726,
      4,
      1,
      4,
      0,
      0.877519,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.324967,
      0.964212,
      1.674395,
      2.101779,
      1,
      2,
      0,
      0,
      1,
      1.575743,
      0,
      3,
      2,
      NULL,
      1,
      1,
      1.320706,
      1,
      5.574590,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.088278,
      NULL,
      NULL,
      0.717378,
      1,
      0,
      3,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1.885898,
      1.587861,
      NULL,
      1.509715,
      0,
      1.887297,
      1.032007,
      0.464869,
      1,
      NULL,
      0.349696,
      2,
      NULL,
      0.604023,
      1,
      0,
      NULL,
      1.480237,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898044,
      0,
      4,
      0,
      1.042541,
      NULL,
      0.973290,
      7.372249,
      NULL,
      5,
      5.091190,
      4.286277,
      4.366285,
      1.256278,
      0.265770,
      5.720408,
      1,
      0.924796,
      0.774212,
      4.877277,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.387932,
      NULL,
      0,
      0,
      0.218897,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.983399,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      1.740441,
      NULL,
      0.470336,
      1.771124,
      0,
      NULL,
      NULL,
      0.470850,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.742352,
      1.628130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419883,
      2.872587,
      2.799298,
      1,
      NULL,
      3.736252,
      1.751957,
      1,
      0.476174,
      NULL,
      0,
      NULL,
      0.115704,
      1,
      1.280282,
      NULL,
      0,
      0.247976,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.928524,
      '00110',
      '',
      '',
      1.966012,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      3,
      1.118941,
      2,
      3,
      2,
      1.163813,
      2.211183,
      NULL,
      3);
commit;
end;
/


