set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2201',
      '11223112',
      42.428541,
      47.926542,
      NULL,
      26.833950,
      1,
      0,
      0,
      NULL,
      NULL,
      '11-19-2000',
      NULL,
      1,
      0,
      NULL,
      1.036349,
      1,
      2,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1.265491,
      1,
      NULL,
      1.943284,
      0.193188,
      3.785084,
      3.808100,
      2,
      4,
      4,
      4,
      1,
      4.262060,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.048611,
      NULL,
      NULL,
      6,
      NULL,
      1.083517,
      2.525666,
      NULL,
      NULL,
      NULL,
      3.323428,
      1.086963,
      NULL,
      3.606349,
      0,
      3,
      3.420284,
      NULL,
      0.471379,
      NULL,
      1.207822,
      1.490414,
      0,
      0.908781,
      NULL,
      6.355052,
      1,
      NULL,
      1.790621,
      0.982049,
      NULL,
      NULL,
      0.062942,
      NULL,
      NULL,
      0.187397,
      1.558978,
      1.180730,
      0,
      0.442322,
      0.926953,
      0.923075,
      0.825138,
      1,
      1,
      1.628712,
      1.307796,
      1.750898,
      0,
      NULL,
      0,
      1.392174,
      1.533753,
      1,
      NULL,
      0.244425,
      5,
      1,
      1.967831,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.501768,
      NULL,
      2.114725,
      1,
      3,
      NULL,
      NULL,
      2.272249,
      2.939778,
      NULL,
      5.770547,
      NULL,
      5.831422,
      4.118135,
      3.219599,
      5.766684,
      0.323474,
      1.993594,
      0,
      9.192820,
      1.210533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.641864,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556006,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      0,
      3,
      1.186207,
      NULL,
      NULL,
      0.242199,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856144,
      NULL,
      0,
      0,
      2,
      2,
      2,
      2,
      0.991491,
      NULL,
      3.080581,
      0,
      1,
      0.699064,
      1,
      1.521135,
      0.209902,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.434503,
      NULL,
      '',
      '',
      0.409984,
      '',
      '',
      '',
      2,
      '4340',
      NULL,
      NULL,
      3.800653,
      NULL,
      2,
      NULL,
      2.343111,
      NULL,
      1.018799,
      2,
      0);
commit;
end;
/


