set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0203',
      '21320031',
      68,
      31.331912,
      '1323224',
      75,
      6,
      0.828618,
      0,
      '423131',
      0,
      ' 5-18-1981',
      50,
      33,
      1.804074,
      NULL,
      0,
      1.345971,
      1,
      NULL,
      1,
      0.400751,
      0,
      1,
      1.977249,
      NULL,
      4,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1.787320,
      5,
      1.040298,
      NULL,
      1,
      0.468668,
      NULL,
      0,
      1.254555,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.656847,
      NULL,
      1,
      2,
      1,
      0.238745,
      2,
      1,
      1,
      3,
      0.874675,
      NULL,
      2.514013,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1.118697,
      4,
      NULL,
      1,
      2,
      0.551943,
      1.126632,
      NULL,
      NULL,
      1.016078,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.504553,
      0,
      0,
      NULL,
      NULL,
      1,
      0.315669,
      0.311969,
      1,
      1.732967,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      5.785260,
      0.017879,
      NULL,
      5.834142,
      1.098425,
      4.009528,
      1,
      NULL,
      1.857722,
      1.539220,
      3,
      2.073598,
      NULL,
      2.085941,
      0.266643,
      NULL,
      5.145035,
      5,
      1.161812,
      6.448112,
      5,
      0,
      6,
      NULL,
      0,
      0.698463,
      5,
      2,
      0,
      1.254584,
      NULL,
      1.265963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921532,
      0.261860,
      1,
      1,
      1,
      0,
      1.725312,
      1.276465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.203343,
      1.497488,
      NULL,
      NULL,
      NULL,
      1.925986,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.989475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.818907,
      3.786504,
      0,
      3.458284,
      NULL,
      3,
      3.095014,
      NULL,
      NULL,
      2,
      NULL,
      1.493021,
      NULL,
      NULL,
      1,
      0.201214,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '11032',
      '',
      '',
      0.195902,
      '',
      '',
      '',
      0,
      '3301',
      '',
      '',
      3.735559,
      1.544439,
      1,
      2,
      0.787291,
      NULL,
      0.792393,
      2.822898,
      0);
commit;
end;
/


