set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3372312';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4200',
      '23411231',
      29,
      NULL,
      NULL,
      5.535565,
      3,
      1.873103,
      3,
      '000103',
      4,
      ' 7-27-1997',
      40.400646,
      24.682569,
      0,
      NULL,
      0,
      3.381676,
      1,
      1.734291,
      1.994790,
      0.067090,
      1.739781,
      1.752251,
      0,
      NULL,
      1.840111,
      1,
      0.902587,
      NULL,
      1,
      0.904037,
      3,
      1.887056,
      0.064150,
      0.951295,
      2,
      1,
      0.276789,
      0,
      3,
      2.925211,
      1,
      1,
      NULL,
      NULL,
      3.808939,
      1,
      NULL,
      0,
      0.483646,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902684,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.650333,
      0,
      NULL,
      1.108216,
      1.301475,
      1.064192,
      0.526664,
      0.315282,
      1,
      0,
      1.290864,
      1,
      NULL,
      NULL,
      1,
      1.989915,
      NULL,
      1,
      NULL,
      NULL,
      0.336848,
      NULL,
      5,
      1,
      2,
      0,
      0,
      2.446365,
      1.666436,
      6.512329,
      3,
      2.490506,
      2.069568,
      4.223566,
      1.499544,
      3.801254,
      7,
      4,
      NULL,
      0,
      NULL,
      2.606075,
      NULL,
      1.566738,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147913,
      1.610002,
      NULL,
      1,
      NULL,
      0,
      0.115043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.010680,
      NULL,
      5,
      3,
      NULL,
      5.682699,
      NULL,
      0.158991,
      3,
      3.798424,
      NULL,
      2.915206,
      NULL,
      3.559782,
      2,
      0,
      1.010113,
      6.875751,
      NULL,
      4.033770,
      0.534681,
      7.499385,
      2,
      0.013527,
      0.891103,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4.153712,
      6,
      1.386394,
      1.834622,
      1,
      0.115255,
      3.697076,
      1.148238,
      3,
      2.163468,
      1,
      NULL,
      NULL,
      NULL,
      1.797327,
      1,
      NULL,
      0,
      0.188638,
      NULL,
      1,
      0,
      NULL,
      1.650230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.056282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.047647,
      '13220',
      '0123',
      '',
      NULL,
      '31141',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      3,
      2.211076,
      0.813240,
      3.625050,
      1,
      1.701622,
      3,
      2);
commit;
end;
/


