set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3372312';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4323',
      '42032411',
      14,
      13.083320,
      '0004242',
      5,
      5,
      2,
      NULL,
      '130230',
      2,
      ' 5-17-2002',
      8.924355,
      63.880515,
      0.372310,
      NULL,
      0.375157,
      NULL,
      NULL,
      0,
      0,
      0.344716,
      1.372518,
      1,
      1.544404,
      NULL,
      1,
      NULL,
      NULL,
      3.851825,
      NULL,
      0.169844,
      6,
      1.868539,
      2,
      0.326474,
      1.268106,
      NULL,
      0.272171,
      1,
      NULL,
      3,
      1.526395,
      1.587146,
      NULL,
      NULL,
      1,
      NULL,
      2.929498,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.698824,
      2.853161,
      1,
      0.665153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.383124,
      NULL,
      2.089850,
      3,
      NULL,
      0,
      1.300297,
      0.315180,
      0,
      0.242395,
      0,
      0,
      NULL,
      1.904260,
      NULL,
      0,
      0,
      1.669020,
      NULL,
      0,
      NULL,
      1.780001,
      0.031145,
      1.065388,
      1,
      1.726235,
      1,
      2,
      1.685174,
      2,
      4.984056,
      NULL,
      1,
      4,
      0.882943,
      2,
      NULL,
      3,
      1,
      3.827410,
      6,
      6.313836,
      5,
      7.998857,
      NULL,
      NULL,
      0.034456,
      3.970324,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362387,
      1,
      0,
      1,
      0.995872,
      1.330777,
      0.621045,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.698322,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.135884,
      NULL,
      2,
      9,
      3,
      1,
      5,
      0.355835,
      NULL,
      NULL,
      0.440774,
      NULL,
      2,
      NULL,
      3,
      7.111192,
      2,
      0,
      1.515229,
      1,
      3.474421,
      3,
      0.726992,
      3,
      3,
      2.300534,
      0.728594,
      NULL,
      1,
      0.489704,
      0.692468,
      1.539615,
      1,
      NULL,
      0,
      0.048132,
      1.811767,
      1.367611,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.042518,
      '22112',
      '3430',
      '',
      3.080360,
      '42033',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      4,
      0.508165,
      NULL,
      0,
      3.896272,
      3.342973,
      3,
      2,
      1.681907);
commit;
end;
/


