set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3372312';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1241',
      NULL,
      71,
      3.181850,
      '3110113',
      13.720955,
      0,
      1,
      3,
      '233032',
      1.109206,
      ' 6- 4-1999',
      17,
      43,
      1,
      NULL,
      0.533634,
      2.448977,
      0,
      0,
      NULL,
      1.794654,
      1.353723,
      1.832751,
      2.530856,
      NULL,
      2.149716,
      0,
      5.485215,
      2,
      1,
      0,
      NULL,
      1,
      0,
      0.827681,
      NULL,
      0.383139,
      2,
      1,
      0.663044,
      0,
      2.869640,
      0,
      NULL,
      NULL,
      3,
      5.227959,
      NULL,
      0.391968,
      1.570794,
      0.605524,
      0.111626,
      1.709778,
      NULL,
      3,
      0.148334,
      0.425001,
      1.820910,
      0.921436,
      1,
      0,
      1.670522,
      0,
      2,
      1,
      0,
      1,
      0.903884,
      1,
      1,
      4,
      0,
      0,
      2.143183,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      5.745283,
      NULL,
      1,
      5,
      NULL,
      1,
      0.096356,
      1.816951,
      1,
      0.391354,
      0,
      1,
      0.589327,
      1.506178,
      1,
      0,
      NULL,
      0.688801,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.587009,
      1.904728,
      0.140601,
      NULL,
      0.411770,
      0,
      NULL,
      NULL,
      1,
      4,
      1,
      3,
      5.644232,
      4,
      3.040200,
      7,
      7,
      2,
      0.840903,
      2.263461,
      0,
      0,
      1.799644,
      3,
      1,
      1.250294,
      2.245121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1.452278,
      NULL,
      1.199994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.870004,
      NULL,
      2,
      0.006961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.371695,
      3,
      1.027267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      5,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      NULL,
      1,
      3,
      9,
      0.266680,
      1.359098,
      NULL,
      3.269531,
      1,
      0.761536,
      3.060131,
      1.573267,
      NULL,
      2,
      NULL,
      0.008326,
      0,
      1.940640,
      1,
      NULL,
      NULL,
      0.027359,
      1,
      0.351648,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.461961,
      NULL,
      '3320',
      '',
      2.861565,
      '34203',
      '',
      '',
      0.701479,
      NULL,
      NULL,
      '',
      3.495792,
      0,
      0.902499,
      2,
      0.635606,
      1.299402,
      1.407157,
      0,
      0);
commit;
end;
/


