set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3372312';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2134',
      '00134441',
      35,
      13.742242,
      '0441243',
      NULL,
      6,
      3.486471,
      1,
      '432434',
      NULL,
      ' 1-11-2003',
      36,
      35,
      1.718536,
      NULL,
      0,
      3.269129,
      1.260273,
      NULL,
      NULL,
      1.495334,
      1,
      1.565507,
      2,
      1,
      3.421886,
      0.471360,
      0.211296,
      0.443216,
      1,
      1.243605,
      NULL,
      0,
      1.559572,
      0.040835,
      1.792010,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375817,
      1,
      1.134444,
      0.562014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6.648514,
      1,
      0,
      4.618880,
      0.044410,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0.296801,
      1,
      1.282310,
      1,
      0.864521,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.568036,
      0,
      0,
      0,
      1,
      0.724576,
      1,
      2.614695,
      3.309623,
      2,
      5.046145,
      0.322231,
      NULL,
      4.232256,
      1,
      1,
      1.447289,
      NULL,
      1,
      NULL,
      1.205200,
      1,
      5,
      1.239477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.512634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.664746,
      NULL,
      NULL,
      2.893857,
      1,
      5,
      NULL,
      3.935250,
      NULL,
      NULL,
      0.365516,
      7,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.911425,
      NULL,
      1,
      NULL,
      NULL,
      1.460412,
      NULL,
      NULL,
      0.502498,
      12,
      1.297054,
      5.715453,
      5,
      0.166529,
      2.573477,
      1,
      1,
      1,
      0.579962,
      NULL,
      0.019481,
      3.171532,
      0,
      1,
      NULL,
      1.429179,
      3.794282,
      3.132907,
      1.327282,
      NULL,
      0,
      0.052397,
      0,
      0.639603,
      0.339984,
      1.334749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '3201',
      NULL,
      '',
      2.873580,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      3.252110,
      5.518817,
      2,
      0.315286,
      1.421629,
      3,
      1,
      0.164211);
commit;
end;
/


