set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007136';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '2401431',
      NULL,
      4,
      0.020550,
      3,
      '204043',
      2.191490,
      ' 8-15-1983',
      23.502718,
      NULL,
      1,
      NULL,
      NULL,
      0.529404,
      0.414758,
      1,
      3.269830,
      1.503891,
      NULL,
      1,
      NULL,
      0.887033,
      8,
      1.833986,
      NULL,
      1,
      3.075730,
      NULL,
      NULL,
      1,
      3,
      2,
      1.017169,
      1.263425,
      0,
      1,
      2.781972,
      4.861347,
      NULL,
      1.232430,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.397869,
      NULL,
      NULL,
      NULL,
      0,
      3.453316,
      NULL,
      1,
      3.873468,
      0,
      NULL,
      0.916886,
      0.112912,
      1,
      1.617443,
      3.970916,
      1,
      0.406252,
      1.474710,
      1,
      NULL,
      1.728340,
      2,
      2,
      2.417989,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.213712,
      4,
      0.964979,
      3,
      3.892980,
      2.872038,
      1,
      2.981174,
      4,
      0.424692,
      NULL,
      0.257348,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.011947,
      NULL,
      0,
      4,
      NULL,
      0.447254,
      1,
      1.720751,
      4,
      1.766809,
      0,
      2,
      3.986457,
      11,
      NULL,
      0.707045,
      6.118662,
      0.511890,
      4.365460,
      6,
      2,
      NULL,
      9,
      4.433042,
      9.630914,
      4.294466,
      6.515306,
      NULL,
      10,
      7.189377,
      3,
      1,
      NULL,
      5,
      0.045057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.864078,
      NULL,
      0,
      1.839160,
      1,
      0.106663,
      1.233688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130236,
      0,
      3.192526,
      1.856791,
      NULL,
      6,
      1.207689,
      3,
      NULL,
      3.862720,
      0,
      4.486829,
      1,
      1.150291,
      2,
      0,
      NULL,
      1.035798,
      NULL,
      NULL,
      NULL,
      NULL,
      7.791317,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      2,
      0,
      3.399375,
      0,
      0.398414,
      2.244566,
      0.362326,
      3.183299,
      0.165647,
      0.999441,
      1,
      NULL,
      0.199381,
      NULL,
      1.382354,
      1,
      0.379191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.179682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      NULL,
      1.036007,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


