set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      '23410224',
      NULL,
      5.721287,
      '2430433',
      114.120539,
      NULL,
      2,
      2,
      NULL,
      1,
      ' 2-17-1994',
      51.841652,
      39.562185,
      0,
      NULL,
      NULL,
      NULL,
      0.006347,
      NULL,
      0.272142,
      1,
      1.226166,
      1,
      0,
      0,
      0,
      0,
      0,
      1.633583,
      1,
      0.119402,
      1.125755,
      1,
      0.089656,
      1.269705,
      1.951940,
      0.359405,
      NULL,
      1,
      0.034867,
      0.348624,
      1.217299,
      0.425904,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.442132,
      0.400608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225705,
      1.712642,
      NULL,
      NULL,
      1,
      NULL,
      0.465291,
      NULL,
      1.920495,
      0.345746,
      NULL,
      0.553432,
      0,
      NULL,
      0,
      1.307866,
      NULL,
      1.674996,
      1.288085,
      NULL,
      1,
      0.617541,
      NULL,
      1,
      0,
      0.844672,
      1.885386,
      0,
      0.094749,
      1.369065,
      0,
      0.412496,
      0.150619,
      1.093506,
      1,
      1,
      0.270762,
      NULL,
      1.973172,
      1,
      1,
      0.788188,
      1.542793,
      1.294952,
      NULL,
      0.916136,
      1,
      0,
      0.935986,
      NULL,
      NULL,
      9.083448,
      1.948192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.052741,
      1,
      NULL,
      1,
      NULL,
      1,
      0.544836,
      1.094124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.705037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.227830,
      0.833471,
      0.945007,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.337796,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697917,
      1.462346,
      1,
      2.769658,
      0.047623,
      NULL,
      1.929230,
      0.953889,
      1.487358,
      0.982728,
      1,
      0.154723,
      0,
      0.252923,
      0,
      0,
      NULL,
      0.302836,
      NULL,
      0.418706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      '2032',
      '14221',
      '',
      1.259941,
      '',
      '',
      NULL,
      1,
      '2011',
      '',
      '',
      1.714956,
      3,
      0,
      NULL,
      0,
      0.696305,
      0.386945,
      0.440571,
      NULL);
commit;
end;
/


