set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '2141313',
      3.621521,
      NULL,
      NULL,
      0,
      '144302',
      1.184693,
      ' 3-12-1993',
      51.298571,
      NULL,
      1,
      NULL,
      1,
      0.263582,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.527052,
      1,
      1,
      NULL,
      NULL,
      1,
      2.162496,
      1.172712,
      NULL,
      1,
      3.148309,
      3.392386,
      1.576862,
      1,
      0,
      2.159488,
      0,
      3,
      NULL,
      NULL,
      1.397705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349652,
      NULL,
      0.978671,
      3.030284,
      0.400328,
      0,
      1,
      NULL,
      0,
      2.740770,
      0.377053,
      1.982117,
      0.184752,
      0,
      1.356985,
      1.914467,
      0,
      1.632400,
      0.134513,
      1,
      4,
      1.947958,
      NULL,
      NULL,
      2,
      2.248509,
      1,
      NULL,
      NULL,
      1.935115,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      1.338672,
      NULL,
      1,
      1,
      1,
      NULL,
      1.742182,
      1.101362,
      0.726167,
      0.572418,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0.022697,
      NULL,
      6.772155,
      0,
      NULL,
      1,
      1,
      6.598730,
      5,
      1,
      9,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.808199,
      7.367149,
      3.103310,
      7,
      1.796489,
      9,
      NULL,
      3.872616,
      NULL,
      1.438641,
      NULL,
      1.358344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956050,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1.639213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.289594,
      0.663847,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930113,
      4,
      7.501176,
      1.121870,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.974930,
      7.050339,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      NULL,
      2.290466,
      1,
      1.454503,
      0,
      0,
      3.302238,
      1.857717,
      1.040997,
      0,
      0.754653,
      1.544530,
      1,
      0.769218,
      NULL,
      0.525950,
      1.829344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '33232',
      NULL,
      '',
      0.099420,
      '',
      '',
      '',
      1.984067,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


