set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      '4301203',
      10,
      1,
      0.399628,
      2,
      '244403',
      1,
      ' 0- 7-1998',
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      0.637422,
      0,
      0,
      0.855155,
      1.286845,
      0,
      NULL,
      1,
      0,
      0,
      0.964420,
      0.114445,
      0,
      1,
      0.223040,
      1.723781,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      2,
      NULL,
      1,
      NULL,
      1.802734,
      0.183751,
      0.772692,
      0.250863,
      0,
      0.795797,
      0,
      NULL,
      0.885274,
      1,
      NULL,
      1.750432,
      NULL,
      NULL,
      1.814728,
      NULL,
      1,
      0,
      2.898737,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.246237,
      4,
      4.913350,
      2,
      1,
      0,
      1.826771,
      NULL,
      1.326509,
      1,
      1.576065,
      0,
      1,
      1,
      1.269228,
      0,
      NULL,
      0.751416,
      NULL,
      NULL,
      0,
      2.643147,
      1.045750,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      5.177932,
      1,
      1.314595,
      3,
      0,
      6.662787,
      5.876864,
      NULL,
      NULL,
      4,
      0,
      1.602556,
      5,
      9.995028,
      8,
      7,
      4,
      0.466110,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      3,
      1.330872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153352,
      NULL,
      NULL,
      NULL,
      NULL,
      2.766961,
      1.993132,
      NULL,
      1,
      NULL,
      913.684003,
      7,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3.688923,
      1,
      NULL,
      4,
      2,
      0,
      1.455311,
      NULL,
      NULL,
      NULL,
      0.253001,
      NULL,
      0.793964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934337,
      NULL,
      1,
      1.200005,
      0,
      3.969897,
      1,
      NULL,
      NULL,
      NULL,
      0.684238,
      1,
      0,
      NULL,
      0.516453,
      1,
      0,
      1.935377,
      NULL,
      0.107216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '12300',
      '',
      '',
      0,
      '',
      '',
      '',
      1.913360,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


