set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '3421312',
      NULL,
      5,
      2.635226,
      2,
      '444230',
      2.368473,
      ' 7-10-1974',
      4,
      NULL,
      1,
      NULL,
      0,
      0,
      0.442136,
      1,
      1.347830,
      NULL,
      0.374792,
      0.307587,
      0.950697,
      1.453118,
      4.846558,
      NULL,
      0,
      2,
      1.177119,
      1.934345,
      10,
      NULL,
      2,
      1.533891,
      NULL,
      1,
      7,
      2,
      1,
      1,
      1,
      0.945431,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.439997,
      3.850771,
      0,
      2.669320,
      0,
      1,
      0,
      1.326829,
      0.370277,
      0.104543,
      2,
      1,
      1,
      1.064815,
      0,
      2,
      3,
      1.661096,
      0.868887,
      1.756491,
      5.462490,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0.311097,
      NULL,
      NULL,
      NULL,
      5,
      5.398880,
      1.908046,
      2,
      0.796100,
      1,
      0,
      1.278612,
      0.883614,
      1,
      0.416702,
      1,
      1,
      NULL,
      1.308858,
      1,
      1,
      NULL,
      NULL,
      0.272770,
      9,
      1.150394,
      0.189017,
      NULL,
      NULL,
      NULL,
      1.703385,
      9.979734,
      1.376083,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      1.311901,
      10,
      5.537356,
      2.489695,
      2.443143,
      2.773038,
      4.970543,
      9,
      NULL,
      8,
      7,
      7.055893,
      3,
      NULL,
      0,
      2,
      0.808025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.208281,
      1,
      0,
      0.581144,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.190138,
      1,
      0,
      646.451935,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.753159,
      6,
      1,
      0,
      1.898781,
      NULL,
      NULL,
      NULL,
      1.444758,
      3,
      0.676619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.902431,
      2.987523,
      NULL,
      2.343683,
      1.661500,
      1,
      0.810690,
      1,
      NULL,
      0,
      1,
      NULL,
      1.028233,
      1.453863,
      1,
      1,
      0,
      1.922703,
      0.606980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.229180,
      '42433',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


