set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '1311212',
      10.548222,
      3,
      0.584454,
      1,
      '203021',
      1.100302,
      '10- 6-1977',
      3.054294,
      NULL,
      1.641160,
      NULL,
      0.640166,
      NULL,
      1.817399,
      0,
      0.151241,
      3.105683,
      0,
      0,
      1,
      1,
      0.948916,
      0.796490,
      1,
      1.103478,
      1.306710,
      NULL,
      4,
      0.588021,
      NULL,
      NULL,
      0.449393,
      0.162806,
      0.712244,
      0,
      1.925589,
      0.625036,
      0,
      0.380650,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      3,
      1.502742,
      0,
      1,
      0.510149,
      2.248803,
      0,
      3,
      0,
      NULL,
      NULL,
      1.325899,
      0,
      0.080071,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4.451338,
      NULL,
      2,
      1,
      1.447587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577381,
      0,
      1,
      1.402956,
      0.562441,
      0,
      1.115197,
      0.732898,
      1,
      1.552827,
      1,
      0.273817,
      0,
      NULL,
      NULL,
      1,
      1,
      0.672653,
      0.636978,
      NULL,
      NULL,
      1,
      1.346026,
      0,
      5.826681,
      0,
      NULL,
      0,
      1,
      0.566961,
      5,
      3.109380,
      0,
      2,
      6.321789,
      7.864387,
      6.650867,
      5,
      NULL,
      1,
      7,
      8,
      4.405506,
      4.262939,
      6,
      3,
      14.772885,
      2,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802588,
      NULL,
      NULL,
      1,
      0.942847,
      2,
      0.308112,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287230,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.076615,
      NULL,
      1,
      6.012089,
      1.360556,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647626,
      1.839814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      3.400481,
      NULL,
      1.153285,
      1,
      1.007355,
      1,
      NULL,
      1.865957,
      0,
      1.582809,
      1.842727,
      0.039991,
      0,
      0.715726,
      0.776170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '32340',
      NULL,
      '',
      0.578710,
      '',
      '',
      '',
      1.822345,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


