set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      24.090297,
      2,
      0.716817,
      1,
      '042414',
      NULL,
      NULL,
      22,
      NULL,
      1.794592,
      NULL,
      0,
      NULL,
      0,
      1.854692,
      1.064694,
      1,
      0,
      1,
      0,
      1.241119,
      5,
      0,
      0.718467,
      0.230663,
      0.611502,
      1,
      9.849640,
      2.784203,
      NULL,
      1.106447,
      NULL,
      1.264646,
      4.994065,
      1,
      2.064225,
      0.846460,
      1.694870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.777486,
      2,
      0,
      1,
      1.451190,
      0.431413,
      0,
      2.077773,
      0.804889,
      2,
      NULL,
      0.786972,
      NULL,
      1.625259,
      3,
      0.758162,
      0.057181,
      1,
      NULL,
      1,
      1,
      0.418273,
      7.486796,
      1,
      2,
      NULL,
      1.073181,
      NULL,
      NULL,
      1.391602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578587,
      NULL,
      0.196793,
      NULL,
      1,
      0,
      0.227862,
      0.889870,
      0.679862,
      0,
      0.751120,
      0.411229,
      NULL,
      NULL,
      NULL,
      0.813734,
      7.893348,
      0.679820,
      1,
      NULL,
      1.365476,
      9,
      1.669462,
      9.998813,
      0.188232,
      2,
      0,
      7,
      0.175222,
      0,
      5.771747,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      6.407285,
      3.941092,
      2.266784,
      NULL,
      5,
      NULL,
      2.307621,
      0.040561,
      NULL,
      5.909131,
      1.820675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0.101615,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.501318,
      1.277709,
      2.549650,
      2.466093,
      154,
      0.422348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.057827,
      0.602659,
      5.917483,
      1.190677,
      NULL,
      3,
      1.633352,
      NULL,
      NULL,
      1,
      8.433793,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.643970,
      3.703245,
      1.571038,
      1,
      NULL,
      2,
      1.914341,
      3.184911,
      2.153055,
      0.159014,
      0,
      NULL,
      1,
      1.716506,
      0.020422,
      0,
      0,
      0.086546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '12020',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


