set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      0,
      1,
      3,
      '223022',
      2.697406,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.640346,
      0.119393,
      NULL,
      0.707989,
      0.759713,
      3,
      NULL,
      NULL,
      0,
      0.965370,
      1,
      0.496481,
      1.141610,
      0.314873,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326493,
      NULL,
      0.728798,
      0,
      1.225115,
      0,
      5.367317,
      0.691494,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.693738,
      2.887593,
      5,
      NULL,
      0.071645,
      NULL,
      0.772277,
      2,
      0.068767,
      3.533992,
      1,
      1,
      0.175414,
      NULL,
      1.323781,
      0,
      2.593684,
      1,
      0,
      2.939959,
      1.276278,
      1.495681,
      3,
      0,
      0,
      0,
      1.111949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.320009,
      1.159587,
      1.504810,
      NULL,
      NULL,
      NULL,
      1.233915,
      NULL,
      1,
      NULL,
      0,
      0,
      1.530536,
      1,
      NULL,
      0.807036,
      0.223480,
      0.963426,
      NULL,
      0.224809,
      NULL,
      1.219266,
      3.879722,
      4,
      1,
      6,
      NULL,
      7.011414,
      6,
      6,
      2.566094,
      5.173061,
      1,
      6,
      1,
      7,
      3,
      7.471731,
      0,
      0,
      7,
      NULL,
      NULL,
      5,
      7.472495,
      7.679729,
      NULL,
      NULL,
      1.156813,
      0.335296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0.544275,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      1,
      0,
      0.729824,
      0.141498,
      NULL,
      1,
      3.474350,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      0.522272,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353174,
      1,
      3,
      0.635657,
      1.498706,
      NULL,
      NULL,
      2.174791,
      1,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.183455,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.507407,
      '00033',
      NULL,
      NULL,
      0.770151,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


