set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '1322404',
      NULL,
      0,
      3.170320,
      0,
      '304422',
      3,
      ' 0- 6-1974',
      NULL,
      NULL,
      0.504507,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.090857,
      NULL,
      NULL,
      1,
      1.939431,
      1.542750,
      NULL,
      1.434470,
      NULL,
      4.575476,
      0.218806,
      0.591785,
      5.442918,
      0.222067,
      1,
      NULL,
      1.404330,
      0,
      5.990135,
      0,
      5.904613,
      0,
      NULL,
      0.487943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.815954,
      2.451841,
      0,
      2,
      1,
      1.178766,
      NULL,
      NULL,
      0,
      2.844746,
      2.918862,
      NULL,
      3,
      3.475860,
      1.811335,
      0.743883,
      2.738435,
      NULL,
      0,
      7,
      1,
      2,
      0.942892,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.919089,
      0,
      NULL,
      5,
      3,
      0,
      1.593125,
      1.636590,
      NULL,
      1,
      0.524856,
      0,
      1,
      0,
      0.475704,
      NULL,
      1.045658,
      0.034700,
      1,
      NULL,
      1.891212,
      8,
      0,
      1,
      6,
      0,
      3.010568,
      NULL,
      5.127384,
      0,
      2.556607,
      0,
      7,
      5,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.784270,
      NULL,
      5,
      3.267065,
      NULL,
      2,
      6,
      3.298196,
      0.321445,
      1.845257,
      4.770908,
      1.876919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.503621,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.280440,
      1,
      1.100862,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      1.894033,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      6,
      1.184710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126238,
      1,
      3,
      1.464616,
      NULL,
      0,
      NULL,
      1.354701,
      1,
      3,
      1.518359,
      0.952476,
      0,
      0,
      1,
      0.967056,
      0.447903,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '30444',
      '',
      '',
      0,
      '',
      '',
      '',
      1.474234,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


