set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '2134020',
      NULL,
      1,
      1,
      0,
      NULL,
      2.306622,
      ' 3-24-1983',
      49,
      NULL,
      0.926854,
      NULL,
      10,
      0,
      1.418390,
      NULL,
      0,
      2,
      1.784513,
      1,
      0.305561,
      0,
      0,
      1,
      0.247953,
      NULL,
      0,
      0.059329,
      5,
      0.811495,
      3,
      3,
      NULL,
      1,
      1,
      0,
      3,
      0,
      1.912397,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      0.881808,
      2,
      0.224494,
      1.549865,
      0,
      1.257622,
      0,
      1.497004,
      1.685273,
      NULL,
      0.956474,
      0.814372,
      0,
      1,
      2.291017,
      3,
      1,
      1,
      2,
      0,
      0.009585,
      NULL,
      NULL,
      0.037264,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3.102315,
      2,
      NULL,
      0.205914,
      0.140944,
      1,
      1,
      1,
      NULL,
      0.335040,
      0.427193,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1.583510,
      NULL,
      0,
      NULL,
      2,
      1.838968,
      8,
      0,
      0.194360,
      3,
      6.972330,
      4.657254,
      NULL,
      5.952164,
      7.035362,
      1,
      1.432323,
      5,
      2.839120,
      6,
      3,
      6.706315,
      NULL,
      NULL,
      3.683239,
      4.013072,
      5.761991,
      NULL,
      0,
      NULL,
      1.177037,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497661,
      1,
      1,
      0,
      0.071533,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.364741,
      0.704588,
      2.266911,
      NULL,
      1.411265,
      0,
      NULL,
      0.962171,
      3.095423,
      6.005905,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.471712,
      5.956758,
      2.114844,
      5.626338,
      0,
      1.678603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323658,
      1.570152,
      3.148443,
      1.427536,
      3,
      2.423588,
      0,
      3,
      1.071621,
      2,
      NULL,
      0,
      NULL,
      1,
      1.602137,
      NULL,
      0,
      1.498853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.063736,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


