set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '3301133',
      NULL,
      NULL,
      3.984787,
      3,
      NULL,
      3,
      ' 9-24-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      12.917556,
      0.108789,
      0,
      NULL,
      0.675709,
      0.431509,
      0,
      0,
      0.858433,
      1.492314,
      NULL,
      0,
      0,
      1.977184,
      1,
      1.288179,
      6,
      0.729139,
      1,
      4,
      NULL,
      0.590532,
      4,
      1,
      NULL,
      1.991713,
      3.132607,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      3.730235,
      0.093851,
      1,
      0,
      1.097816,
      3,
      2,
      NULL,
      0.450337,
      0.052888,
      NULL,
      0.748898,
      0,
      3.701566,
      1.698718,
      1,
      1,
      2,
      1,
      1.681316,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.901441,
      0.311299,
      0.040238,
      3,
      0,
      NULL,
      0.568227,
      0,
      NULL,
      1.270975,
      1.632027,
      1,
      0,
      NULL,
      NULL,
      0,
      1.259114,
      0.431562,
      NULL,
      1,
      8.968766,
      0,
      5,
      5,
      0.774856,
      9,
      1.590344,
      4,
      1,
      3,
      0.480810,
      4,
      5.043768,
      7,
      1,
      3,
      3.737663,
      NULL,
      7.930498,
      2,
      NULL,
      1,
      1.277917,
      3,
      2,
      NULL,
      4.586269,
      3,
      1,
      1.580832,
      2.724127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064827,
      0,
      1,
      1,
      0.891640,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.689838,
      2.852652,
      1.664609,
      2,
      2,
      3,
      1,
      0.694045,
      2.830236,
      NULL,
      1.449459,
      1,
      NULL,
      NULL,
      NULL,
      0.886839,
      7,
      6.564485,
      7,
      3,
      1,
      0.924479,
      NULL,
      NULL,
      NULL,
      0.822796,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700865,
      3.576337,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      0.910728,
      0.532789,
      0,
      0,
      0.656778,
      NULL,
      1,
      1,
      0,
      1.717619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24233',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


