set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '2312040',
      NULL,
      0,
      2.947149,
      1,
      '003244',
      1.269851,
      NULL,
      37.814685,
      NULL,
      0.648491,
      NULL,
      19,
      1,
      1,
      NULL,
      1,
      0.483668,
      1,
      NULL,
      2.565869,
      0,
      NULL,
      NULL,
      0.748025,
      1,
      1.754833,
      5,
      4,
      3.294676,
      1.123318,
      4.737100,
      0.489711,
      6.129815,
      1.584594,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.394172,
      NULL,
      NULL,
      0.130849,
      2,
      5,
      0.164313,
      1,
      NULL,
      2,
      NULL,
      3,
      0,
      0.110004,
      1,
      2.210393,
      NULL,
      0,
      NULL,
      2.126192,
      0,
      1.803391,
      0.283988,
      1.406514,
      6,
      1.709650,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.279659,
      1.211567,
      0,
      1.639447,
      NULL,
      NULL,
      NULL,
      1,
      1.265157,
      0.988605,
      1,
      1,
      0.116268,
      1,
      1.489056,
      NULL,
      NULL,
      1.475894,
      0.256782,
      NULL,
      NULL,
      2,
      1,
      3,
      2.836802,
      1.945963,
      3.240993,
      0.733298,
      8.140820,
      4,
      1,
      0,
      5,
      2.611591,
      7,
      1,
      5,
      NULL,
      2,
      1,
      1,
      2,
      0.198847,
      5.390500,
      7,
      2,
      10.988176,
      NULL,
      NULL,
      1,
      0,
      4.674406,
      1.000225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.250013,
      NULL,
      0,
      0,
      1.537308,
      0.492347,
      0.732839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.417653,
      NULL,
      0,
      0.003291,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323887,
      0.629227,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      4.019467,
      4,
      0.630111,
      0,
      4.469655,
      NULL,
      NULL,
      NULL,
      1,
      10.601401,
      1.790810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.240589,
      1,
      0,
      NULL,
      0.287927,
      0,
      0,
      2.127400,
      0,
      0.607957,
      NULL,
      1,
      0.924635,
      0.201524,
      NULL,
      0.600139,
      1.650488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '33023',
      '',
      '',
      0.458311,
      '',
      '',
      '',
      0.672291,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


