set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '4324211',
      21.054257,
      2,
      0,
      0,
      '010324',
      2.111477,
      ' 1-18-1990',
      47.712695,
      NULL,
      1.536224,
      NULL,
      1.577612,
      0.019557,
      1.357148,
      1,
      0,
      0,
      1.666631,
      1,
      0.218041,
      NULL,
      2.833903,
      1.900111,
      NULL,
      0,
      1,
      NULL,
      5.464562,
      7,
      NULL,
      2,
      1.073345,
      0,
      6.708036,
      0,
      5.804168,
      0,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.881586,
      0.957889,
      1.572732,
      1.965041,
      3.086915,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      1.643272,
      0,
      NULL,
      NULL,
      0.993595,
      1,
      0,
      1.542023,
      1,
      6.252029,
      1,
      1,
      1,
      0.359339,
      1.734474,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.727786,
      1.848451,
      0,
      1,
      1.151909,
      NULL,
      0.330274,
      1.484380,
      NULL,
      NULL,
      1.908607,
      0,
      1,
      0,
      NULL,
      1.993790,
      1.754153,
      0.176932,
      NULL,
      1.516379,
      4,
      1.280392,
      1.117325,
      4.589506,
      NULL,
      1,
      0,
      2.382943,
      4,
      2,
      3.730434,
      0,
      NULL,
      NULL,
      NULL,
      2.385098,
      2,
      4,
      2,
      2,
      4,
      NULL,
      1.518797,
      3.437330,
      1.120659,
      11,
      5.610906,
      NULL,
      1,
      NULL,
      1.229571,
      1.234830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432419,
      1,
      1,
      1,
      1,
      1.742144,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.927157,
      0.306084,
      0,
      1.814654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3.772981,
      NULL,
      3.433360,
      7,
      0.141121,
      1,
      2.323705,
      NULL,
      NULL,
      NULL,
      0.606376,
      6.364140,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125370,
      3.739351,
      1.728377,
      1.604725,
      1.837331,
      3,
      NULL,
      0,
      1.760381,
      2,
      1.822471,
      NULL,
      0.287881,
      1,
      0.440595,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '12232',
      '',
      '',
      0.944116,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


